# TODO: Progressbar reversal for restoration
# TODO: If backup and restore function is mostly duplicated, combine to single
# TODO: For restoration, include checkboxes for existing files and 'folderaskopendialogue' button for new path
# TODO: Instead of the progress label indication failure, try to incorprate directly into the progress bar
# TODO: INFO button should switch to window that shows currenlty selected restore opens. If possible the log and local
#       vault information can be natively displayed.
# TODO: Backup alternative incase Everything is not present or the service is not running. Xcopy with exclusions list or
#       Robocopy.
# TODO: Add search capability to restore/vault contents view
# TODO: Try to implement a local MFT extraction procedure. If successfull, then Everything can be coded out.
# TODO: Instead of rescanning the location, use a dictionary with Everything to compare which files still need to be backed up.
# TODO: Change the state/color of buttons when copying/restoring
# FIXME: Use ICACLS for folder permissions -https://theitbros.com/using-icacls-to-list-folder-permissions-and-manage-files/

import ctypes
import time
import struct
import os
import zlib
import logging
import threading
import tkinter as tk
import tkinter.messagebox
from os import scandir
from tkinter import filedialog
from tkinter import ttk
from pathlib import Path
from datetime import datetime, timezone
from subprocess import Popen, PIPE
from collections import OrderedDict
from ttkwidgets import CheckboxTreeview  # pip install ttkwidgets
from contextlib import suppress


# generate daily timestamp
timestamp = round(datetime.now(timezone.utc).replace(hour=0, minute=0, second=0, microsecond=0).timestamp())

# show results
if not os.path.isdir('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/last_backup/'):
    os.makedirs('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/last_backup/', exist_ok=True)
if not os.path.isdir('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/Vault/'):
    os.makedirs('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/Vault/', exist_ok=True)

date_time = time.strftime("%m-%d-%Y")
log_file = f'\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/{date_time}.log'
logging.basicConfig(filename=log_file, level=logging.WARNING, format='%(asctime)s // %(message)s ', datefmt='%Y-%m-%d %H:%M:%S')

# defines
EVERYTHING_REQUEST_FILE_NAME = 0x00000001
EVERYTHING_REQUEST_PATH = 0x00000002
EVERYTHING_REQUEST_FULL_PATH_AND_FILE_NAME = 0x00000004
EVERYTHING_REQUEST_EXTENSION = 0x00000008
EVERYTHING_REQUEST_SIZE = 0x00000010
EVERYTHING_REQUEST_DATE_CREATED = 0x00000020
EVERYTHING_REQUEST_DATE_MODIFIED = 0x00000040
EVERYTHING_REQUEST_DATE_ACCESSED = 0x00000080
EVERYTHING_REQUEST_ATTRIBUTES = 0x00000100
EVERYTHING_REQUEST_FILE_LIST_FILE_NAME = 0x00000200
EVERYTHING_REQUEST_RUN_COUNT = 0x00000400
EVERYTHING_REQUEST_DATE_RUN = 0x00000800
EVERYTHING_REQUEST_DATE_RECENTLY_CHANGED = 0x00001000
EVERYTHING_REQUEST_HIGHLIGHTED_FILE_NAME = 0x00002000
EVERYTHING_REQUEST_HIGHLIGHTED_PATH = 0x00004000
EVERYTHING_REQUEST_HIGHLIGHTED_FULL_PATH_AND_FILE_NAME = 0x00008000
EVERYTHING_SORT_PATH_ASCENDING = 0x00000003

# dll imports
everything_dll = ctypes.WinDLL("C:\\EverythingSDK\\DLL\\Everything64.dll")
everything_dll.Everything_GetResultDateModified.argtypes = [ctypes.c_int, ctypes.POINTER(ctypes.c_ulonglong)]
everything_dll.Everything_GetResultSize.argtypes = [ctypes.c_int, ctypes.POINTER(ctypes.c_ulonglong)]

# FIXME: Check why some .EXE files (e.g. FND32) are indexed when not present in the ext list.

# setup search
everything_dll.Everything_SetSearchW(
    "cdt|*.indd|*.mpt|*.ppt|*.sxi|*.wps|*.cpt|*.indt|*.mst|*.pptm|*.sxw|*.wpt|*.csv|*.jah|*.pat|*.pptx|*.thmx|*.xla|"
    "*.dbf|*.jbh|*.pdf|*.prm|*.vdx|*.xlam|*.doc|*.jbw|*.pmd|*.pub|*.vsd|*.xls|*.docm|*.jfw|*.pot|*.qpw|*.vst|*.xlsb|"
    "*.docx|*.jhw|*.potm|*.qxd|*.vsx|*.xlsm|*.dot|*.jtd|*.potx|*.qxt|*.vtx|*.xlsx|*.dotm|*.jtt|*.ppa|*.rtf|*.wcm|*.xlt|"
    "*.dotx|*.juw|*.ppam|*.scx|*.wks|*.xltm|*.dwg|*.jvw|*.pps|*.shw|*.wpd|*.xltx|*.dxf|*.lzh|*.ppsm|*.sxd|*.wpg|*.xps|"
    "*.has|*.mpp|*.ppsx|*.template|*.pages|*.key|*.numbers|*.kth|*.qdf|*.qif|*.qel|*.qph|*.idx|*.qsd|*.qpd|*.qfp|*.qdt|"
    "*.qdb|*.qby|*.qbx|*.exp|*.qbb|*.iif|*.qbw|*.tax|*.tax2008|*.q00|*.q01|*.q03|*.q04|*.q98|*.q99|*.qb1|*.qba|*.qbi|"
    "*.qbm|*.qdi|*.qfd|*.qfg|*.qfi|*.qfx|*.qmd|*.qmt|*.qnx|*.qpb|*.qph|*.qtx|*.qw5|*.qw6|*.txt|*.epub")
everything_dll.Everything_SetRequestFlags(
    EVERYTHING_REQUEST_FILE_NAME | EVERYTHING_REQUEST_PATH | EVERYTHING_REQUEST_SIZE | EVERYTHING_REQUEST_DATE_CREATED | EVERYTHING_REQUEST_DATE_MODIFIED)
everything_dll.Everything_SetSort(EVERYTHING_SORT_PATH_ASCENDING)

# execute the query
everything_dll.Everything_QueryW(1)

# get the number of results
num_results = everything_dll.Everything_GetNumResults()

# convert a windows FILETIME to a python datetime
# https://stackoverflow.com/questions/39481221/convert-datetime-back-to-windows-64-bit-filetime
WINDOWS_TICKS = int(1 / 10 ** -7)  # 10,000,000 (100 nanoseconds or .1 microseconds)
WINDOWS_EPOCH = datetime.strptime('1601-01-01 00:00:00',
                                           '%Y-%m-%d %H:%M:%S')
POSIX_EPOCH = datetime.strptime('1970-01-01 00:00:00',
                                         '%Y-%m-%d %H:%M:%S')
EPOCH_DIFF = (POSIX_EPOCH - WINDOWS_EPOCH).total_seconds()  # 11644473600.0
WINDOWS_TICKS_TO_POSIX_EPOCH = EPOCH_DIFF * WINDOWS_TICKS  # 116444736000000000.0


def get_time(filetime):
    """Convert windows filetime winticks to python datetime.datetime."""
    winticks = struct.unpack('<Q', filetime)[0]
    microsecs = (winticks - WINDOWS_TICKS_TO_POSIX_EPOCH) / WINDOWS_TICKS
    return datetime.fromtimestamp(microsecs)


# create buffers
filename = ctypes.create_unicode_buffer(1024)
date_modified_filetime = ctypes.c_ulonglong(1)
file_size = ctypes.c_ulonglong(1)


# get total size of all files
def total_all_file_size():
    calc_total_size = 0
    for t in range(num_results):
        everything_dll.Everything_GetResultSize(t, file_size)
        calc_total_size += file_size.value
    return calc_total_size


total_size = total_all_file_size()
if total_size < 1024000000:
    restore_size = str(round(total_size / 1024000, 2)) + 'MB'
else:
    restore_size = str(round(total_size / 1024000000, 2)) + 'GB'

################################################
# GUI
################################################

# root window
root = tk.Tk()
root.geometry('850x250')
root.title('MyBackup')
root.resizable(False, False)
win_main = tk.Frame(root, width=820, height=250)
win_main.pack(fill=None, expand=False)

size_done = progress_percent = file_number = count_success = count_fail = file_is_folder = empty_file = backed_up = display_size = modified_files = 0
stop_it = 'no'
running = 'no'
AFTER = None

################################################################################################################
################################################################################################################
################################################################################################################
################################################################################################################

def backup_start():
    global size_done, progress_percent, stop_it, count_success, count_fail, file_is_folder, empty_file, file_number, running, backed_up, display_size, total_size, modified_files, file_size, restore_size

    def size_of_file():
        global display_size, restore_size
        if file_size.value < 1024:
            display_size = str(file_size.value) + 'B'
        elif 1024 <= file_size.value < 1024000:
            display_size = str(round(file_size.value/1024, 2)) + 'KB'
        elif 1024000 <= file_size.value < 1024000000:
            display_size = str(round(file_size.value/1024000, 2)) + 'MB'
        elif file_size.value >= 1024000000:
            display_size = str(round(file_size.value/1024000000, 2)) + 'GB'

        if total_size-size_done < 1024000000:
            restore_size = str(round((total_size-size_done)/1024000, 2)) + 'MB'
        else:
            restore_size = str(round((total_size-size_done)/1024000000, 2)) + 'GB'

        return result_size.set(f"Total transferable size left: {restore_size}  |  Current file size: {display_size}")

    def the_progress():
        global progress_percent
        progress_percent = (size_done / total_size) * 100
        if 99.99 > progress_percent >= 10:
            progress_percent_txt = str(round((size_done / total_size) * 100, 2)).ljust(5, '0')
        elif progress_percent < 10:
            progress_percent_txt = str(round((size_done / total_size) * 100, 2)).ljust(4, '0')
        else:
            progress_percent_txt = f'Complete. Files successfully transferred = {100 - round(count_fail / num_results * 100, 2)}'
        pb['value'] = max(progress_percent, smooth_bar)

        return result_percent.set(f"Total progress: {progress_percent_txt}%")

    go_red = 'yes'
    go_orange = 'yes'
    go_yellow = 'yes'
    def change_color():
        global AFTER
        nonlocal go_red, go_orange, go_yellow
        if progress_percent >= 95 and go_yellow == 'yes':
            next_color = "light yellow"
            go_yellow = 'no'
        elif 90 <= progress_percent < 95 and go_orange == 'yes':
            next_color = "orange"
            go_orange = 'no'
        elif progress_percent < 90 and go_red == 'yes':
            next_color = "red"
            go_red = 'no'
        else:
            next_color = ""
            go_orange = 'yes'
            go_red = 'yes'
            go_yellow = 'yes'
        percent_label.config(background=next_color)
        AFTER = root.after(1000, change_color)

    running = 'yes'
    count_log = 1
    smooth_bar = progress_percent

    modified_file_check = []
    modified_file_check = Path("\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/").rglob("*![([*")
    modified_file_check_list = list(modified_file_check)
    file_paths = 'C:'

    for file_num in range(num_results):
        root.update_idletasks()
        pb['value'] = max(smooth_bar, progress_percent)
        pb_2['value'] = 0
        if stop_it == 'yes':
            break

        file_is_modified = 'no'
        is_backed_up = 'no'
        already_backed_up = 'no'
        file_number = file_num + 1
        everything_dll.Everything_GetResultDateModified(file_num, date_modified_filetime)
        file_date = round(get_time(date_modified_filetime).timestamp())
        everything_dll.Everything_GetResultSize(file_num, file_size)
        everything_dll.Everything_GetResultFullPathNameW(file_num, filename, 1024)
        file_path = '\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files\\' + ctypes.wstring_at(filename)[3:]

        file_name = ctypes.wstring_at(filename).rpartition('\\')[-1]

        if os.path.isfile(ctypes.wstring_at(filename)) and int(os.path.getsize(ctypes.wstring_at(filename))) >= 1:  # Is 'file' a file and also at least 100 bytes in size
            result_count.set(f"Current count: {file_number}/{num_results}")

            file_paths = ctypes.wstring_at(filename).rpartition('\\')[0:-2][0]
            if len(file_path) < 101:
                result_folder.set(f"Current folder: {file_paths}")
            else:
                result_folder.set(f"Current folder: {file_paths[:70] + '...' + file_paths[-30:]}")

            if len(file_name) < 101:
                result_file.set(f"Current file: {file_name}")
            else:
                result_file.set(f"Current file: {file_name[:70] + '...' + file_name[-30:]}")

            size_of_file()

            f = bytes(f"{filename.value}", encoding="utf-8")  # Encode file's full path to byte characters for CRC
            f_open = open(ctypes.wstring_at(filename), 'rb')  # Open file in raw bytes
            lines = f_open.readlines()[:1]  # Read byte contents of file. First line only
            crc = zlib.crc32(f) + zlib.crc32(
                lines[0][:2].rstrip())  # CRC value addition from path and 1st line of content
            check_file = str(file_path) + ' ![([' + str(crc) + ',' + str(file_size.value) + ',' + str(
                file_date) + ',' + str(timestamp) + '])]!'  # CRC check file format

        the_progress()
        smooth_bar = progress_percent

        try:
            for latest in modified_file_check_list:
                latest_str = str(latest)
                check_file_breaks = str(latest_str.partition(' ![([')[-1][:-4]).split(',')
                check_file_name = str(latest_str.partition(' ![([')[0])
                if check_file_name.replace('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files', 'C:') == ctypes.wstring_at(filename):
                    is_backed_up = 'yes'
                    if '.txt' in check_file_name.replace('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files', 'C:') and int(file_size.value) > 0 and int(file_date) > int(check_file_breaks[2]):
                        fline = open(check_file_name.replace('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files', 'C:')).readline().rstrip()
                        if fline:
                            file_is_modified = 'yes'
                            modified_files += 1
                            break
                    elif str(crc) == str(check_file_breaks[0]) and int(file_size.value) > 0 and int(file_date) > int(check_file_breaks[2]):
                        file_is_modified = 'yes'
                        modified_files += 1
                        break
                    else:
                        break
                else:
                    is_backed_up = 'no'

            if file_is_modified == 'no' and is_backed_up == 'yes':
                backed_up += 1
                size_done += file_size.value
                result_transfer.set(f"Success: {count_success}  |  Fail: {count_fail}  |  File is a folder: {file_is_folder}  |  File is empty: {empty_file}  |  Modified: {modified_files}  |  In vault: {backed_up}")
                continue

            output_file = Path(file_path)
            output_file.parent.mkdir(exist_ok=True, parents=True)

            exist_path = os.listdir(file_path.rpartition('\\')[0])
            substring = any(ctypes.wstring_at(filename).rpartition('\\')[-1] in string for string in exist_path)
            if substring:
                for path in exist_path:
                    if str(ctypes.wstring_at(filename).rpartition('\\')[-1]) == str(str(ctypes.wstring_at(path).rpartition('\\')[-1]).rpartition(' ![([')[0]):
                        backed_up += 1
                        already_backed_up = 'yes'
                        break

            if already_backed_up == 'yes' and file_is_modified == 'no':
                break
            if (already_backed_up == 'yes' and file_is_modified == 'yes') or already_backed_up == 'no':
                if file_paths == 'C:':
                    file_paths = 'C:\\'
                os.chdir(file_paths)

                temp_add_to_progress = 0

# TODO: The whole process breaks if there is filename to be replaced that is longer than ??? length. That windows filepath limit
#       Check if Robocopy has the ability to ignore such limits or implement a secondary backupper just for the said files.
                set_marker = 'no'
                cmd = ['robocopy', file_paths, output_file.parent, file_name, '/R:0', '/W:0', '/IS', '/IT', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True) as p:

                    for file_progress in p.stdout:
                        pb['value'] = smooth_bar
                        if '%' in file_progress:  # process line here
                            pb_2['value'] = float(file_progress.rstrip().rpartition('%')[0])
                            file_percent.set(f"File progress: {str(file_progress.rstrip().rpartition('%')[0])}%")
                            add_to_total_progress = (file_size.value/total_size) * float(file_progress.rstrip().rpartition('%')[0])

                            smooth_add_to_progress = add_to_total_progress
                            if set_marker == 'yes':
                                smooth_add_to_progress = add_to_total_progress - temp_add_to_progress
                                set_marker = 'no'
                            if set_marker == 'no':
                                temp_add_to_progress = add_to_total_progress
                                set_marker = 'yes'

                            pb['value'] += smooth_add_to_progress
                            result_percent.set(f"Total progress: {round(pb['value'], 2)}%")
                            smooth_bar += smooth_add_to_progress

                    if os.path.isfile(f'{output_file.parent}\\{file_name}'):
                        for file in Path(output_file.parent).glob(f"{file_name} ![([*"):
                            file.unlink()
                        with open(check_file, 'w') as check_out:
                            count_success += 1
                            with open(f'\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/Vault/vault.txt', "a", encoding="utf-8") as vault_list:
                                vault_list.write(f'{output_file.parent}\\{file_name}' + "\n")
                    else:
                        raise Exception
            elif os.path.isdir(ctypes.wstring_at(filename)):
                file_is_folder += 1
            elif int(os.path.getsize(ctypes.wstring_at(filename))) == 0:
                empty_file += 1
            else:
                raise Exception
        except Exception as ex:
            count_fail += 1
            logging.error(f'{count_log}. Size:{file_size.value};;  IsFile:{os.path.isfile(ctypes.wstring_at(filename))};;  lenPath:{len(ctypes.wstring_at(filename))};;  Filename:{filename.value};;  ERROR: %% {ex} %%')
            count_log += 1

        size_done += file_size.value
        size_of_file()
        the_progress()

        result_transfer.set(f"Success: {count_success}  |  Fail: {count_fail}  |  File is a folder: {file_is_folder}  |  File is empty: {empty_file}  |  Modified: {modified_files}  |  In vault: {backed_up}")

        if file_num == range(num_results)[-1]:
            with open(f'\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/last_backup/{timestamp}', 'w') as date_out:
                pass
            running = 'no'

    with open('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/Vault/vault.txt', "r", encoding="utf-8") as fin:
        lines = (line.rstrip() for line in fin)
        unique_lines = OrderedDict.fromkeys((line for line in lines if line))
    with open(f'\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/Vault/vault.txt', "w", encoding="utf-8") as vault_list:
        for line in unique_lines.keys():
            vault_list.write(line + "\n")

    logging.shutdown()

    if progress_percent < 100:
        change_color()

    stop_it = 'yes'


################################################################################################################
################################################################################################################
################################################################################################################
################################################################################################################


def restore_start():
    # global compare_check, checked, ready_to_restore, file_exist_option, restore_location
    # cmd = ['robocopy', compare_check.get(sid)[0], 'G:\\Restore', compare_check.get(sid)[1], '/R:0', '/W:0', '/IS', '/IT', '/NDL', '/NS',
    # for sid in checked:
    #     if sid in compare_check.keys():
    #         print(sid, compare_check.get(sid))
    # print(file_exist_option, restore_location, ready_to_restore, checked)

    #     for file_progress in p.stdout:
    #         pb['value'] = smooth_bar
    #         if '%' in file_progress:  # process line here
    #             pb_2['value'] = float(file_progress.rstrip().rpartition('%')[0])
    #             file_percent.set(f"File progress: {str(file_progress.rstrip().rpartition('%')[0])}%")
    #             add_to_total_progress = (file_size.value / total_size) * float(
    #                 file_progress.rstrip().rpartition('%')[0])
    #
    #             smooth_add_to_progress = add_to_total_progress
    #             if set_marker == 'yes':
    #                 smooth_add_to_progress = add_to_total_progress - temp_add_to_progress
    #                 set_marker = 'no'
    #             if set_marker == 'no':
    #                 temp_add_to_progress = add_to_total_progress
    #                 set_marker = 'yes'
    #
    #             pb['value'] += smooth_add_to_progress
    #             result_percent.set(f"Total progress: {round(pb['value'], 2)}%")
    #             smooth_bar += smooth_add_to_progress

    def restore_1():    # Original location and skip
        print('rest1')
        for sid in checked:
            if sid in compare_check.keys():
                current_path = compare_check.get(sid)[0]
                current_path_file = compare_check.get(sid)[2]
                restore_path = 'H:\\#Restored' + compare_check.get(sid)[1]
                with suppress(Exception):
                    cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/XC', '/XN', '/XO', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                    with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True) as p:
                        pass


    def restore_2():    # Original location and rename
        print('I am on restor_2)')
        for sid in checked:
            if sid in compare_check.keys():
                current_path = compare_check.get(sid)[0]
                current_path_file = compare_check.get(sid)[2]
                restore_path = 'H:\\#Restored' + compare_check.get(sid)[1]
                exist_path = restore_path + '\\' + current_path_file
                if os.path.isfile(exist_path):
# FIXME: This might cause an issue if the string has more than 1 dot. eg. ....... Try rsplit which splits from right to left
                    head, sep, tail = str(current_path_file).rpartition('.')
                    for num in range(1000):
                        exist_path_num = restore_path + '\\' + head + ' (' + str(num) + ')' + '.' + tail
                        if os.path.isfile(exist_path_num):
                            continue
                        else:
                            with suppress(Exception):
                                os.rename(exist_path, exist_path_num)
                                cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/XC', '/XN', '/XO', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                                with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True):
                                    break
                else:
                    with suppress(Exception):
                        cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/XC', '/XN', '/XO', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                        with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True):
                            pass


    def restore_3():    # Original location and overwrite
        print('rest3')
        for sid in checked:
            if sid in compare_check.keys():
                current_path = compare_check.get(sid)[0]
                current_path_file = compare_check.get(sid)[2]
                restore_path = 'H:\\#Restored' + compare_check.get(sid)[1]
                with suppress(Exception):
                    cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/IS', '/IT', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                    with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True):
                        pass


    def restore_4():    # Custom location and skip
        print('rest4')
        for sid in checked:
            if sid in compare_check.keys():
                current_path = compare_check.get(sid)[0]
                current_path_file = compare_check.get(sid)[2]
                restore_path = restore_location + compare_check.get(sid)[1]
                print(current_path, current_path_file, restore_path, restore_location, compare_check.get(sid)[1])
                with suppress(Exception):
                    print('I made it')
                    cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/XC', '/XN', '/XO', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                    with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True):
                        pass

# FIXME: The indexing of the treeview still seems broken. Test by creating new files in various places
    def restore_5():    # Custom location and rename
        print('rest5')
        for sid in checked:
            if sid in compare_check.keys():
                current_path = compare_check.get(sid)[0]
                current_path_file = compare_check.get(sid)[2]
                restore_path = restore_location + compare_check.get(sid)[1]
                exist_path = restore_path + '\\' + current_path_file
                print(sid, current_path, current_path_file, restore_path)
                if os.path.isfile(exist_path):
                    print('no')
                    head, sep, tail = str(current_path_file).rpartition('.')
                    for num in range(1000):
                        exist_path_num = restore_path + '\\' + head + ' (' + str(num) + ')' + '.' + tail
                        if os.path.isfile(exist_path_num):
                            continue
                        else:
                            with suppress(Exception):
                                os.rename(exist_path, exist_path_num)
                                cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/XC',
                                       '/XN', '/XO', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                                with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True):
                                    break
                else:
                    print('yes')
                    print(current_path, restore_path, current_path_file,)
                    with suppress(Exception):
                        cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                        with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True):
                            pass


    def restore_6():    # Custom location and overwrite
        print('rest6')
        for sid in checked:
            if sid in compare_check.keys():
                current_path = compare_check.get(sid)[0]
                current_path_file = compare_check.get(sid)[2]
                restore_path = restore_location + compare_check.get(sid)[1]
                with suppress(Exception):
                    cmd = ['robocopy', current_path, restore_path, current_path_file, '/R:0', '/W:0', '/IS', '/IT', '/NDL', '/NS', '/NC', '/NJH', '/NJS']
                    with Popen(cmd, stdout=PIPE, bufsize=1, universal_newlines=True):
                        pass


    if ready_to_restore == 'yes' and restore_location == 'original':
        if file_exist_option == 'Skip':
            restore_1()
        elif file_exist_option == 'Rename':
            restore_2()
        elif file_exist_option == 'Overwrite':
            restore_3()
    elif ready_to_restore == 'yes':
        if file_exist_option == 'Skip':
            restore_4()
        elif file_exist_option == 'Rename':
            restore_5()
        elif file_exist_option == 'Overwrite':
            restore_6()

    pb['value'] = 100

    def change_dir():
        for value in range(100):
            pb['value'] -= 1
            time.sleep(0.025)

    change_dir()

    input()


################################################################################################################
################################################################################################################
################################################################################################################
################################################################################################################


# Export result of Everything Query to txt file
def everything_list():
    for every in Path("\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/").glob("*everything.txt"):
        every.unlink()

    filename = ctypes.create_unicode_buffer(1024)
    for t in range(num_results):
        everything_dll.Everything_GetResultFullPathNameW(t, filename, 1024)
        outputting = ctypes.wstring_at(filename)
        with open(f'\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/{date_time}.everything.txt', "a", encoding="utf-8") as output:
            try:
                output.write(outputting + "\n")
            except:
                output.write('FAILED\n')


def backup():
    global stop_it, num_results, running, size_done, progress_percent, count_success, count_fail, file_is_folder, empty_file, file_number, backed_up, display_size, total_size, modified_files

    root.geometry('850x250')
    restore_button.configure(state='disabled')

    everything_thread = threading.Thread(target=everything_list)
    everything_thread.daemon = True
    everything_thread.start()

    if running == 'no':
        size_done = progress_percent = file_number = count_success = count_fail = file_is_folder = empty_file = backed_up = display_size = total_size = modified_files = 0
        stop_it = 'no'

        everything_dll.Everything_QueryW(1)
        num_results = everything_dll.Everything_GetNumResults()
        total_size = total_all_file_size()
        pb['value'] = progress_percent = 0
        backup_thread = threading.Thread(target=backup_start)
        backup_thread.daemon = True
        backup_thread.start()


iid = 1
ready_to_restore = 'no'
file_exist_option = 'Skip'
restore_location = 'original'
checked = []
compare_check = {}
def restore():
    global ready_to_restore, iid

    if ready_to_restore == 'no':
        root.geometry('850x715')
        backup_button.configure(state='disabled')
        restore_button.configure(state='disabled')

    if ready_to_restore == 'yes':
        root.geometry('850x250')
        backup_button.configure(state='disabled')

    win_treeview = tk.Frame(root, width=850, height=465)
    win_treeview.place(x=0, y=250, anchor="nw", width=850, height=465)
    style = ttk.Style(win_treeview)

    ttk.Label(win_treeview, text="Select File(s) \ Folder(s) to restore", font='arial 10 bold').place(x=300, y=0)

    v_scrollbar = tk.Scrollbar(win_treeview, orient='vertical')
    v_scrollbar.place(x=830, y=20, width=20, height=380)
    tree = CheckboxTreeview(win_treeview, show='tree', yscrollcommand=v_scrollbar.set)
    tree.place(x=10, y=20, anchor="nw", width=815, height=380)
    v_scrollbar.config(command=tree.yview)
    style.configure('Treeview', indent=15)

    # https://stackoverflow.com/questions/68078498/recursively-arrange-all-folders-and-files-in-a-hierarchical-treeview-in-tkinter
    def new_folder(parent_path, parent_iid):
        global iid, compare_check
        for name in os.scandir(parent_path):
            view_name = str(name)[11:-2]
            if name.is_dir():
                subdir_iid = tree.insert(parent=parent_iid, index='end', text=f'[F] {view_name}')
                try:
                    new_folder(parent_path=name.path, parent_iid=subdir_iid)
                except PermissionError:
                    pass
            else:
                tree.insert(parent=parent_iid, index='end', text=f'[f] {view_name}')

            iid += 1
            hex_iid = hex(iid)
            hex_in_folder = str(hex_iid)[2:].upper()
            hex_compare = hex_in_folder

            if len(hex_compare) >= 3:
                hex_compare = 'I' + str(hex_in_folder)
            elif len(hex_compare) == 2:
                hex_compare = 'I0' + str(hex_in_folder)
            elif len(hex_compare) == 1:
                hex_compare = 'I00' + str(hex_in_folder)

            iid = int(hex_iid, 16)
            compare_check.update({hex_compare: [parent_path, parent_path[14:], view_name]})

        return compare_check

    def get_checked():
        global ready_to_restore, checked
        if len(checked) > 0:
            checked = []

        def rec_get_checked(item):
            if tree.tag_has('checked', item):
                checked.append(item)
            for ch in tree.get_children(item):
                rec_get_checked(ch)
            return checked
        rec_get_checked('')

        if len(checked) == 0:
            tk.messagebox.showinfo("Nothing to restore.", "You have not selected any item to restore")
            return

        restore_button.configure(text='Start Restore')
        restore_button.configure(state='normal')
        root.geometry('850x250')
        ready_to_restore = 'yes'
        print(checked)
        # return checked

    def file_exist():
        global file_exist_option
        if var.get() == 1:
            file_exist_option = 'Overwrite'
        if var.get() == 2:
            file_exist_option = 'Rename'
        if var.get() == 3:
            file_exist_option = 'Skip'

    def browse_save():
        global restore_location
        restore_location = tk.filedialog.askdirectory()
        if restore_location == '':
            restore_location = 'original'
            checkbutton_var.set(4)
            save_location.set('All selected files and folders will be saved to their original location')
        else:
            save_location.set(restore_location)

    def original_save():
        global restore_location
        restore_location = 'original'
        save_location.set('All selected files and folders will be saved to their original location')

    def expand_children():
        def aux(item):
            tree.item(item, open=True)
            children = tree.get_children(item)
            for c in children:
                aux(c)

        children = tree.get_children("")
        for c in children:
            aux(c)

    def collapse_children():
        def aux(item):
            tree.item(item, open=False)
            children = tree.get_children(item)
            for c in children:
                aux(c)

        children = tree.get_children("")
        for c in children:
            aux(c)

# TODO: The treeview view should revert to a main parent and direct descendants layout, as it is on open
    def clear_options():
        checkbutton_var.set(4)
        original_save()

        var.set(3)
        file_exist()

        children = tree.get_children('')
        for iid in children:
            tree.change_state(iid, "unchecked")
            tree._uncheck_descendant(iid)

    with suppress(Exception):
        if ready_to_restore == 'yes':
            restore_thread = threading.Thread(target=restore_start)
            restore_thread.daemon = True
            restore_thread.start()

    parent_iid = tree.insert(parent='', index='0', text='All Documents', open=True)
    start_path = os.path.expanduser(r"\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files")
    new_folder(parent_path=start_path, parent_iid=parent_iid)

    var = tk.IntVar()
    checkbutton_var = tk.IntVar()
    save_location = tk.StringVar()
    col_exp_butt = ttk.Button(win_treeview, text='Expand Tree', state='normal', style="Custom.TButton", width=14, command=expand_children)
    col_exp_butt.place(x=10, y=405)
    col_col_butt = ttk.Button(win_treeview, text='Collapse Tree', state='normal', style="Custom.TButton", width=14, command=collapse_children)
    col_col_butt.place(x=10, y=435)
    accept_butt = ttk.Button(win_treeview, text='Accept Options', state='normal', style="Custom.TButton", width=14, command=get_checked)
    accept_butt.place(x=120, y=405)
    clear_butt = ttk.Button(win_treeview, text='Clear Options', state='normal', style="Custom.TButton", width=14, command=clear_options)
    clear_butt.place(x=120, y=435)
    radiobox_label = ttk.Label(win_treeview, text='If file exists: ')
    radiobox_label.place(x=240, y=420)
    radio_box_1 = ttk.Radiobutton(win_treeview, text="Overwrite", variable=var, value=1, command=file_exist)
    radio_box_1.place(x=310, y=400)
    radio_box_2 = ttk.Radiobutton(win_treeview, text="Rename", variable=var, value=2, command=file_exist)
    radio_box_2.place(x=310, y=420)
    radio_box_3 = ttk.Radiobutton(win_treeview, text="Skip", variable=var, value=3, command=file_exist)
    radio_box_3.place(x=310, y=440)
    var.set(3)
    location_label = ttk.Label(win_treeview, text='Restore to location: ')
    location_label.place(x=450, y=410)
    radio_box_4 = ttk.Radiobutton(win_treeview, text="Original location", variable=checkbutton_var, value=4, command=original_save)
    radio_box_4.place(x=560, y=410)
    radio_box_5 = ttk.Radiobutton(win_treeview, text="Custom location", variable=checkbutton_var, value=5, command=browse_save)
    radio_box_5.place(x=670, y=410)
    location_entry = tk.Entry(win_treeview, font='arial 10 bold', textvariable=save_location, state='disabled', width=62, justify='center')
    location_entry.place(x=405, y=435)
    checkbutton_var.set(4)
    save_location.set('All selected files and folders will be saved to their original location')

    win_treeview.mainloop()


def reset():
    global stop_it, running, size_done, progress_percent, file_number, count_success, count_fail, file_is_folder, empty_file, backed_up, display_size, modified_files, total_size, ready_to_restore, AFTER

    root.geometry('850x250')
    backup_button.configure(state='normal')
    restore_button.configure(state='normal')
    restore_button.configure(text='Restore Options')
    ready_to_restore = 'no'
    with suppress(ValueError):
        root.after_cancel(AFTER)

    count_refresh = 0
    while count_refresh < 5:
        pb['value'] = 0
        pb_2['value'] = 0

        size_done = progress_percent = file_number = count_success = count_fail = file_is_folder = empty_file = backed_up = display_size = modified_files = 0

        stop_it = 'yes'
        running = 'no'

        result_folder.set(f"Current folder: ")
        result_percent.set(f"Total progress: {progress_percent}%")
        file_percent.set(f"File progress: {progress_percent}%")
        result_file.set(f"Current file: ")
        result_count.set(f"Current count: {file_number}/{num_results}")
        result_transfer.set(f"Success: {count_success}  |  Fail: {count_fail}  |  File is a folder: {file_is_folder}  |  File is empty: {empty_file}  |  Modified: {modified_files}  |  In vault: {backed_up}")
        result_size.set(f"Total transferable size left: {round((total_size - size_done) / 1000000, 2)}MB  |  Current file size: {display_size}")

        root.update()
        time.sleep(0.1)
        count_refresh += 1


def open_log():
    if os.path.isfile(log_file):
        os.startfile(log_file, 'open')


def vault_listing():
    if os.path.isfile('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/Vault/vault.txt'):
        os.startfile('\\\\DESKTOP-PSDOFNO\Check_Files2\\Check_Files/[#log#]/Vault/vault.txt', 'open')


def info():
    pass


file_paths = ctypes.wstring_at(filename).rpartition('\\')[0:-2][0]
result_folder = tk.StringVar()
result_folder.set(f"Current folder: {file_paths}")
result_percent = tk.StringVar()
result_percent.set(f"Total progress: {progress_percent}%")
file_percent = tk.StringVar()
file_percent.set(f"File progress: {progress_percent}%")
result_file = tk.StringVar()
result_file.set(f"Current file: {ctypes.wstring_at(filename)}")
result_count = tk.StringVar()
result_count.set(f"Current count: {file_number}/{num_results}")
result_transfer = tk.StringVar()
result_transfer.set(f"Success: {count_success}  |  Fail: {count_fail}  |  File is a folder: {file_is_folder}  |  File is empty: {empty_file}  |  Modified: {modified_files}  |  In vault: {backed_up}")
result_size = tk.StringVar()
result_size.set(f"Total size left to transfer: {restore_size}  |  Current file size: {display_size}")

# progressbar
pb = ttk.Progressbar(win_main, orient='horizontal', mode='determinate', length=800)
pb.grid(column=0, row=1, columnspan=6, padx=10, pady=5)
pb_2 = ttk.Progressbar(win_main, orient='horizontal', mode='determinate', length=800)
pb_2.grid(column=0, row=5, columnspan=6, padx=10, pady=5)

# labels
percent_label = ttk.Label(win_main, textvariable=result_percent)
percent_label.grid(column=0, row=0, columnspan=6)
file_percent_label = ttk.Label(win_main, textvariable=file_percent)
file_percent_label.grid(column=0, row=4, columnspan=6)
folder_label = ttk.Label(win_main, textvariable=result_folder)
folder_label.grid(column=0, row=2, columnspan=6)
file_label = ttk.Label(win_main, textvariable=result_file)
file_label.grid(column=0, row=3, columnspan=6)
count_label = ttk.Label(win_main, textvariable=result_count)
count_label.grid(column=0, row=7, columnspan=6)
size_label = ttk.Label(win_main, textvariable=result_transfer)
size_label.grid(column=0, row=8, columnspan=6)
transfer_label = ttk.Label(win_main, textvariable=result_size)
transfer_label.grid(column=0, row=9, columnspan=6)

# buttons
backup_button = ttk.Button(win_main, text='Backup', width=14, command=backup)
backup_button.grid(column=0, row=10, padx=10, pady=10, sticky=tk.NSEW)
restore_button = ttk.Button(win_main, text='Restore Options', width=14, command=restore)
restore_button.grid(column=1, row=10, padx=10, pady=10, sticky=tk.NSEW)
reset_button = ttk.Button(win_main, text='Stop/Reset', width=14, command=reset)
reset_button.grid(column=2, row=10, padx=10, pady=10, sticky=tk.NSEW)
log_button = ttk.Button(win_main, text="Log", width=14, command=open_log)
log_button.grid(column=5, row=10, padx=10, pady=10, sticky=tk.NSEW)
vault_button = ttk.Button(win_main, text="Vault", width=14, command=vault_listing)
vault_button.grid(column=3, row=10, padx=10, pady=10, sticky=tk.NSEW)
info_button = ttk.Button(win_main, text="Info", width=14, command=info)
info_button.grid(column=4, row=10, padx=10, pady=10, sticky=tk.NSEW)


root.mainloop()
